<?php
/**
 * Revoke Rank
 *
 * @package     AutomatorWP\Integrations\GamiPress\Actions\Revoke_Rank
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_GamiPress_Revoke_Rank extends AutomatorWP_Integration_Action {

    public $integration = 'gamipress';
    public $action = 'gamipress_revoke_rank';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Revoke rank', 'automatorwp-pro' ),
            'select_option'     => __( 'Revoke <strong>rank</strong>', 'automatorwp-pro' ),
            /* translators: %1$s; Post title. */
            'edit_label'        => sprintf( __( 'Revoke the rank: %1$s', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s; Post title. */
            'log_label'         => sprintf( __( 'Revoke the rank: %1$s', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name' => __( 'Rank:', 'automatorwp-pro' ),
                    'option_default' => __( 'Select an rank', 'automatorwp-pro' ),
                    'option_none' => false,
                    'post_type' => gamipress_get_rank_types_slugs()
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $post_id = absint( $action_options['post'] );

        $post = get_post( $post_id );

        // Bail if post doesn't exists
        if( ! $post ) {
            return;
        }

        // Bail if post is not an rank
        if( ! in_array( $post->post_type, gamipress_get_rank_types_slugs() ) ) {
            return;
        }

        // Revoke the rank
        gamipress_revoke_rank_to_user( $user_id, $post_id );

    }

}

new AutomatorWP_GamiPress_Revoke_Rank();